<?php
// 允许跨域访问
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Content-Type: application/json; charset=utf-8');

// 引入解析库
require_once __DIR__ . '/src/Bilibili.php';
use Injahow\Bilibili;

// 解析B站URL，提取av、bv或ep参数
function parseBilibiliUrl($url) {
    $result = [];
    
    // 匹配AV号
    if (preg_match('/av(\d+)/i', $url, $matches)) {
        $result['av'] = $matches[1];
    }
    
    // 匹配BV号
    if (preg_match('/BV([0-9A-Za-z]+)/i', $url, $matches)) {
        $result['bv'] = $matches[1];
    }
    
    // 匹配EP号
    if (preg_match('/ep(\d+)/i', $url, $matches)) {
        $result['ep'] = $matches[1];
    }
    
    // 匹配集数
    if (preg_match('/p=(\d+)/i', $url, $matches)) {
        $result['p'] = $matches[1];
    }
    
    return $result;
}

// 从URL路径获取B站链接
$pathInfo = $_SERVER['PATH_INFO'] ?? '';
$bilibiliUrl = trim($pathInfo, '/');

// 如果路径为空，检查POST参数
if (empty($bilibiliUrl) && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $bilibiliUrl = $_POST['url'] ?? '';
}

if (empty($bilibiliUrl)) {
    echo json_encode([
        'code' => 1,
        'message' => '请提供B站视频链接'
    ]);
    exit;
}

// 解析B站链接
$params = parseBilibiliUrl($bilibiliUrl);

if (empty($params)) {
    echo json_encode([
        'code' => 1,
        'message' => '无法解析该B站链接'
    ]);
    exit;
}

// 初始化解析器
$bp = new Bilibili();
$bp->format('mp4'); // 默认使用mp4格式

// 设置解析参数
if (isset($params['av'])) $bp->aid($params['av']);
if (isset($params['bv'])) $bp->bvid($params['bv']);
if (isset($params['ep'])) $bp->epid($params['ep']);
if (isset($params['p'])) $bp->page($params['p']);

// 执行解析
$result = json_decode($bp->result(), true);

if (isset($result['code']) && $result['code'] === 0) {
    // 如果是直接访问且有url参数，自动跳转
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && !empty($result['url'])) {
        header('Location: ' . $result['url']);
        exit;
    }
    
    echo json_encode([
        'code' => 0,
        'url' => $result['url'],
        'quality' => $result['quality']
    ]);
} else {
    echo json_encode([
        'code' => 1,
        'message' => $result['message'] ?? '解析失败'
    ]);
}